/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = `pelvis`;

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];
    for (let m of models) {
        /* Later we create a REPORTER variable to display an explanatory message if any capping
         * limit exceeded */
        let capping_limit_explanation = "";

        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /**Pelvis Score and Modifer */
            let pubic_sym_force_value;
            let pubic_sym_force_score;
            let pelvis_force_capping_limit;
            let pelvis_force_left_value;
            let pelvis_force_left_score;
            let pelvis_force_right_value;
            let pelvis_force_right_score;
            let pelvis_force_left_capping_limit;
            let pelvis_force_right_capping_limit;
            switch (occ) {
                case "DRIVER":
                    pubic_sym_force_value = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_MAX_VALUE`, "float");
                    pubic_sym_force_score = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_SCORE`, "float");
                    pelvis_force_capping_limit = get_variable_value(status, `${m}_${occ}_PELVIS_FORCE_CAPPING_LIMIT`);
                    break;
                case "REAR_DRIVER_SIDE":
                    pelvis_force_left_value = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_LEFT_MAX_VALUE`,
                        "float"
                    );
                    pelvis_force_right_value = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_RIGHT_MAX_VALUE`,
                        "float"
                    );
                    pelvis_force_left_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_LEFT_MAX_SCORE`,
                        "float"
                    );
                    pelvis_force_right_score = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_RIGHT_MAX_SCORE`,
                        "float"
                    );
                    pelvis_force_left_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_LEFT_MAX_CAPPING_LIMIT`
                    );
                    pelvis_force_right_capping_limit = get_variable_value(
                        status,
                        `${m}_${occ}_PELVIS_FORCE_REAR_PASSENGER_RIGHT_MAX_CAPPING_LIMIT`
                    );
                    break;
                default:
                    LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                    Exit();
            }
            /* Final scores all start at zero and will remain so if any variables were missing or invalid */
            let pelvis_score = 0;
            /* Capping limits start as exceeded and will remain so if any variables were missing or invalid */
            let pelvis_capping_limit = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                switch (occ) {
                    case "DRIVER":
                        pelvis_score = Math.max(0, pubic_sym_force_score);

                        if (pelvis_force_capping_limit == "") {
                            pelvis_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    case "REAR_DRIVER_SIDE":
                        pelvis_score = Math.max(0, Math.min(pelvis_force_left_score, pelvis_force_right_score));
                        if (pelvis_force_left_capping_limit == "" && pelvis_force_right_capping_limit == "") {
                            pelvis_capping_limit = "";
                        } else {
                            capping_limit_explanation = `*Capping limit exceeded`;
                        }
                        break;
                    default:
                        LogError(`Unexpected occupant type "${occ}" in ${body_region_label} calculation.`);
                        Exit();
                }
                LogPrint(`${m} ${occ} ${body_region_label} score = ${pelvis_score}`);
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} ${body_region_label} score calculation`);
            }
            //* Overall score */
            let pelvis_score_var = new Variable(
                templ,
                `${m}_${occ}_PELVIS_FINAL_SCORE`,
                `Final ${body_region_label} score`,
                pelvis_score.toString(),
                "String",
                false,
                true
            );
            let pelvis_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_PELVIS_CAPPING_LIMIT`,
                `Pelvis capping limit`,
                pelvis_capping_limit,
                "String",
                false,
                true
            );
        }
        let capping_limit_explanation_var = new Variable(
            templ,
            `${m}_PELVIS_CAPPING_LIMIT_EXPLANATION`,
            `Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
